// Listing 11-6

import java.util.Scanner;
import java.io.*;

public class Listing11_6
{
   public static void main(String[] args) throws IOException
   {  
      // Zmienna, w której zapiszemy pozycję menu
      // wybraną przez użytkownika
      int menuSelection;
      
      do
      {     
         // Wyświetlamy menu
         // i prosimy użytkownika o wybranie operacji
         menuSelection = displayMenu();
   
         // Wykonujemy wybraną operację
         switch(menuSelection)
         {
            case 1:
               addRecord();
               break;
               
            case 2:
               searchRecord();
               break;
               
            case 3:
               modifyRecord();
               break;

            case 4:
               deleteRecord();
               break;

            case 5:
               displayRecords();
               break;
         }
      } while (menuSelection != 6);
   }
   
   // Metoda displayMenu wyświetla menu
   // i prosi użytkownika o wybranie operacji. Metoda waliduje dane wejściowe
   // i zwraca wprowadzoną wartość
   public static int displayMenu()
   {
      // Deklarujemy zmienną, w której zapiszemy
      // pozycję menu, którą wybrał użytkownik
      int selection;

      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Wyświetlamy menu
      System.out.println("         Inventory Menu");
      System.out.println("1. Add a record.");
      System.out.println("2. Search for a record.");
      System.out.println("3. Modify a record.");
      System.out.println("4. Delete a record.");
      System.out.println("5. Display all records.");
      System.out.println("6. End the program.");
      System.out.println();
      
      // Prosimy użytkownika o wybranie operacji
      System.out.print("Wybierz operację.");
      selection = keyboard.nextInt();
      
      // Walidujemy dane wprowadzone przez użytkownika
      while (selection < 1 || selection > 6)
      {
         System.out.println("Nieprawidłowa operacja.");
         System.out.print("Wprowadź 1, 2, 3, 4, 5 lub 6.");
         selection = keyboard.nextInt();
      }
      
      // Zwracamy operację wybraną przez użytkownika
      return selection;
   }
   
   // Metoda addRecord umożliwia dodanie
   // rekordu do pliku
   public static void addRecord() throws IOException
   {
      // Zmienne, w których zapiszemy pola rekordu
      String description;
      double quantity;

      // Zmienna sterująca pętlą
      String another = "T";
      
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Otwieramy plik wyjściowy w trybie dołączania
      PrintWriter coffeeFile = 
         new PrintWriter(new FileWriter("coffee.dat", true));
      
      while (another.equalsIgnoreCase("T"))
      {
         // Pobieramy opis
         System.out.print("Wprowadź nazwę produktu.");
         description = keyboard.nextLine();
         
         // Pobieramy zapas produktu
         System.out.print("Wprowadź ilość produktu" +
                          "(w kilogramach): ");
         quantity = keyboard.nextDouble();
         // Odczytujemy znak końca linii...
         keyboard.nextLine();
         
         // Dołączmy rekord do pliku
         coffeeFile.println(description);
         coffeeFile.println(quantity);
         
         // Sprawdzamy, czy użytkownik ma zamiar wprowadzić
         // kolejny rekord
         System.out.println("Czy chcesz wprowadzić kolejny rekord?");
         System.out.print("Jeśli tak, wpisz T, w przeciwnym razie wpisz dowolny inny znak.");
         another = keyboard.nextLine();
         
         // Wyświetlamy pustą linię
         System.out.println();
      }

      // Zamykamy plik
      coffeeFile.close();
      System.out.println("Dane zostały dopisane do pliku coffee.dat.");
   }

   // Metoda searchRecord umożliwia wyszukanie
   // określonego rekordu w pliku
   public static void searchRecord() throws IOException
   {
      // Zmienne, w których zapiszemy pola rekordu
      String description;
      double quantity;
      
      // Zmienna, w której zapiszemy szukaną wartość
      String searchValue;
      
      // Flaga wskazująca, czy wartość została odnaleziona
      boolean found = false;
      
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Pobieramy szukaną wartość
      System.out.print("Której kawy szukasz?");
      searchValue = keyboard.nextLine();
      
      // Otwieramy plik coffee.dat
      Scanner coffeeFile = new Scanner(new File("coffee.dat"));
      
      // Odczytujemy rekordy z pliku
      while (coffeeFile.hasNext())
      {
         // Odczytujemy rekord z pliku
         // Na wstępie odczytujemy nazwę kawy
         description = coffeeFile.nextLine();
         
         // Następnie odczytujemy ilość
         quantity = coffeeFile.nextDouble();
         // Odczytujemy znak końca linii...
         coffeeFile.nextLine();
         
         // Odczytujemy znak końca linii...
         // wyświetlamy go
         if (description.indexOf(searchValue) != -1)
         {
            System.out.println("Nazwa: " + description);
            System.out.println("Ilość: " + quantity);
            
            // Ustawiamy flagę na true
            found = true;
         }
      }

      // Jeśli szukanej wartość nie udało się odnaleźć,
      // wyświetlamy odpowiedni komunikat
      if (!found)
         System.out.println("Nie znaleziono: " + searchValue);
         
      // Zamykamy plik
      coffeeFile.close();
   }  

   // Metoda modifyRecord umożliwia modyfikację
   // istniejącego już rekordu
   public static void modifyRecord() throws IOException
   {
      // Zmienne, w których zapiszemy pola rekordu
      String description;
      double quantity;
      
      // Zmienna, w której zapiszemy nową ilość produktu
      double newQuantity;
      
      // Zmienna, w której zapiszemy szukaną wartość
      String searchValue;
      
      // Flaga wskazująca, czy wartość została odnaleziona
      boolean found = false;
      
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Otwieramy plik coffee.dat
      Scanner coffeeFile = new Scanner(new File("coffee.dat"));
      
      // Otwieramy plik wyjściowy, do którego skopiujemy plik pierwotny
      PrintWriter tempFile = new PrintWriter(new File("temp.dat"));
      
      // Pobieramy szukaną wartość
      System.out.print("Wprowadź nazwę kawy, której ilość chcesz zmodyfikować.");
      searchValue = keyboard.nextLine();
      
      // Pobieramy nowy zapas produktu
      System.out.print("Wprowadź nową ilość.");
      newQuantity = keyboard.nextDouble();
      
      // Odczytujmey rekordy z pliku
      while (coffeeFile.hasNext())
      {
         // Odczytujemy rekord z pliku
         // Na wstępie odczytujemy nazwę kawy
         description = coffeeFile.nextLine();
         
         // Następnie odczytujemy ilość
         quantity = coffeeFile.nextDouble();
         // Odczytujemy znak końca linii...
         coffeeFile.nextLine();
         
         // Gdy rekord zawiera szukaną wartość, zapisujemy w pliku tymczasowym nowy rekord
         // W przeciwnym razie w pliku tymczasowym zapisujemy odczytany rekord
         if (description.equalsIgnoreCase(searchValue))
         {
            tempFile.println(description);
            tempFile.println(newQuantity);
            found = true;
         }
         else
         {
            tempFile.println(description);
            tempFile.println(quantity);
         }
      }

      // Zamykamy plik pierwotny
      coffeeFile.close();
      
      // Zamykamy plik tymczasowy
      tempFile.close();
      
      // Otwieramy plik pierwotny do zapisu,
      // usuwający tym samym jego zawartość
      PrintWriter coffeeFile2 = new PrintWriter("coffee.dat");
      
      // Otwieramy plik tymczasowy do odczytu
      Scanner tempFile2 = new Scanner(new File("temp.dat"));
      
      // Kopiujemy każdy rekord z pliku tymczasowego 
      // do pliku pierwotnego
      while(tempFile2.hasNext())
      {
         // Odczytujemy rekord z pliku tymczasowego
         description = tempFile2.nextLine();
         quantity = tempFile2.nextDouble();
         tempFile2.nextLine();
         
         // Zapisujemy rekord w pliku pierwotnym
         coffeeFile2.println(description);
         coffeeFile2.println(quantity);
      }
      
      // Zamykamy plik pierwotny
      coffeeFile2.close();
      
      // Zamykamy plik tymczasowy
      tempFile2.close();      

      // Jeśli szukanej wartość nie udało się odnaleźć,
      // wyświetlamy odpowiedni komunikat
      if (!found)
         System.out.println("Nie znaleziono: " + searchValue);
   }
   
   // Metoda deleteRecord umożliwia usunięcie
   // rekordu zapisanego w pliku
   public static void deleteRecord() throws IOException
   {
      // Zmienne, w których zapiszemy pola rekordu
      String description;
      double quantity;
      
      // Zmienna, w której zapiszemy szukaną wartość
      String searchValue;
      
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Otwieramy plik coffee.dat
      Scanner coffeeFile = new Scanner(new File("coffee.dat"));
      
      // Otwieramy plik wyjściowy, do którego skopiujemy plik pierwotny
      PrintWriter tempFile = new PrintWriter(new File("temp.dat"));
      
      // Pobieramy szukaną wartość
      System.out.print("Wprowadź nazwę kawy, którą chcesz usunąć.");
      searchValue = keyboard.nextLine();
      
      // Odczytujemy rekordy z pliku
      while (coffeeFile.hasNext())
      {
         // Odczytujemy rekord z pliku
         // Na wstępie odczytujemy nazwę kawy
         description = coffeeFile.nextLine();
         
         // Następnie odczytujemy ilość
         quantity = coffeeFile.nextDouble();
         // Odczytujemy znak końca linii...
         coffeeFile.nextLine();
         
         // Jeśli nie jest to rekord, który mamy zamiar usunąć,
         // zapisujemy go w pliku tymczasowym
         if (!description.equalsIgnoreCase(searchValue))
         {
            tempFile.println(description);
            tempFile.println(quantity);
         }
      }

      // Zamykamy plik pierwotny
      coffeeFile.close();
      
      // Zamykamy plik tymczasowy
      tempFile.close();
      
      // Otwieramy plik pierwotny do zapisu,
      // usuwający tym samym jego zawartość
      PrintWriter coffeeFile2 = new PrintWriter("coffee.dat");
      
      // Otwieramy plik tymczasowy do odczytu
      Scanner tempFile2 = new Scanner(new File("temp.dat"));
      
      // Kopiujemy każdy rekord z pliku tymczasowego 
      // do pliku pierwotnego
      while(tempFile2.hasNext())
      {
         // Odczytujemy rekord z pliku tymczasowego
         description = tempFile2.nextLine();
         quantity = tempFile2.nextDouble();
         tempFile2.nextLine();
         
         // Zapisujemy rekord w pliku pierwotnym
         coffeeFile2.println(description);
         coffeeFile2.println(quantity);
      }
      
      // Zamykamy plik pierwotny
      coffeeFile2.close();
      
      // Zamykamy plik tymczasowy
      tempFile2.close();      

      System.out.println("Plik został zaktualizowany.");
   }

   // Metoda displayRecords wyświetla wszystkie rekordy
   // zapisane w pliku
   public static void displayRecords() throws IOException
   {
      // Zmienne, w których zapiszemy pola rekordu
      String description;
      double quantity;
      
      // Otwieramy plik coffee.dat
      Scanner coffeeFile = new Scanner(new File("coffee.dat"));
      
      // Wyświetlamy rekordy zapisane w pliku
      while (coffeeFile.hasNext())
      {
         // Odczytujemy rekord z pliku
         // Na wstępie odczytujemy nazwę kawy
         description = coffeeFile.nextLine();
         
         // Następnie odczytujemy ilość
         quantity = coffeeFile.nextDouble();
         // Odczytujemy znak końca linii...
         coffeeFile.nextLine();
         
         // Wyświetlamy rekord
         System.out.println("Nazwa: " + description);
         System.out.println("Ilość: " + quantity);
      }

      // Zamykamy plik
      coffeeFile.close();
   }
}